<?php
require_once 'config/database.php';
require_once 'config/auth.php';
require_once 'includes/functions.php';

$pdo = getDB();

// Get active surveys
$surveys = $pdo->query("SELECT * FROM surveys WHERE status = 'active' ORDER BY created_at DESC")->fetchAll();

$page_title = 'Surveys';
include 'includes/header.php';
?>

<div class="container">
    <div class="surveys-page">
        <h1>Available Surveys</h1>

        <?php if (empty($surveys)): ?>
            <div class="no-surveys">
                <i class="fas fa-poll"></i>
                <p>No surveys are currently available.</p>
            </div>
        <?php else: ?>
            <div class="surveys-grid">
                <?php foreach ($surveys as $survey): ?>
                    <div class="survey-card">
                        <div class="survey-header">
                            <h2><?php echo htmlspecialchars($survey['title']); ?></h2>
                        </div>
                        <div class="survey-description">
                            <p><?php echo htmlspecialchars($survey['description'] ?: 'No description available.'); ?></p>
                        </div>
                        <div class="survey-actions">
                            <a href="survey.php?id=<?php echo $survey['id']; ?>" class="btn btn-primary">
                                <i class="fas fa-play"></i> Take Survey
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include 'includes/footer.php'; ?>